<?php
include "../config/koneksi.php";

/* =========================
   AMBIL DATA MASTER
========================= */
$role    = $conn->query("SELECT * FROM role");
$jabatan = $conn->query("SELECT * FROM jabatan");
$fraksi  = $conn->query("SELECT * FROM fraksi");
$komisi  = $conn->query("SELECT * FROM komisi");
$akd     = $conn->query("SELECT * FROM akd");

/* =========================
   FUNGSI KOMPRES FOTO
   TARGET: <= 25 KB
========================= */
function compressImage($source, $destination, $maxSizeKB = 25) {
    $info = getimagesize($source);
    if (!$info) return false;

    if ($info['mime'] == 'image/jpeg') {
        $image = imagecreatefromjpeg($source);
    } elseif ($info['mime'] == 'image/png') {
        $image = imagecreatefrompng($source);
        imagepalettetotruecolor($image);
    } else {
        return false;
    }

    $quality = 90;
    do {
        ob_start();
        imagejpeg($image, null, $quality);
        $data = ob_get_clean();
        $sizeKB = strlen($data) / 1024;
        $quality -= 5;
    } while ($sizeKB > $maxSizeKB && $quality > 10);

    file_put_contents($destination, $data);
    imagedestroy($image);

    return true;
}

/* =========================
   SIMPAN DATA
========================= */
if (isset($_POST['simpan'])) {

    $nama       = trim($_POST['nama']);
    $email      = trim($_POST['email']);
    $password   = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $role_id    = (int) $_POST['role_id'];
    $jabatan_id = (int) $_POST['jabatan_id'];

    $fraksi_id = !empty($_POST['fraksi_id']) ? (int)$_POST['fraksi_id'] : NULL;
    $komisi_id = !empty($_POST['komisi_id']) ? (int)$_POST['komisi_id'] : NULL;

    /* =========================
       CEK EMAIL
    ========================= */
    $cek = $conn->prepare("SELECT id FROM user WHERE email=?");
    $cek->bind_param("s", $email);
    $cek->execute();
    $cek->store_result();
    if ($cek->num_rows > 0) {
        die("<script>alert('Email sudah terdaftar');history.back();</script>");
    }

    /* =========================
       UPLOAD & KOMPRES FOTO
    ========================= */
    if (!isset($_FILES['foto']) || $_FILES['foto']['error'] !== 0) {
        die("<script>alert('Upload foto gagal');history.back();</script>");
    }

    $ext = strtolower(pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION));
    if (!in_array($ext, ['jpg','jpeg','png'])) {
        die("<script>alert('Format foto harus JPG / PNG');history.back();</script>");
    }

    $upload_path = "../uploads/user/";
    if (!is_dir($upload_path)) {
        mkdir($upload_path, 0777, true);
    }

    $foto = time() . '.jpg';
    $dest = $upload_path . $foto;

    if (!compressImage($_FILES['foto']['tmp_name'], $dest, 25)) {
        die("<script>alert('Gagal kompres foto');history.back();</script>");
    }

    /* =========================
       INSERT USER
    ========================= */
    $stmt = $conn->prepare("
        INSERT INTO user
        (nama,email,password,foto,role_id,jabatan_id,fraksi_id,komisi_id)
        VALUES (?,?,?,?,?,?,?,?)
    ");

    $stmt->bind_param(
        "ssssiiii",
        $nama,
        $email,
        $password,
        $foto,
        $role_id,
        $jabatan_id,
        $fraksi_id,
        $komisi_id
    );

    if (!$stmt->execute()) {
        die("Execute gagal: " . $stmt->error);
    }

    $user_id = $conn->insert_id;

    /* =========================
       INSERT AKD (MULTI)
    ========================= */
    if (!empty($_POST['akd_id']) && is_array($_POST['akd_id'])) {
        $stmtAkd = $conn->prepare("
            INSERT INTO user_akd (user_id, akd_id)
            VALUES (?,?)
        ");
        foreach ($_POST['akd_id'] as $akd_id) {
            $akd_id = (int)$akd_id;
            $stmtAkd->bind_param("ii", $user_id, $akd_id);
            $stmtAkd->execute();
        }
    }

    echo "<script>
        alert('Anggota berhasil disimpan (foto dikompres)');
        window.location='input_anggota.php';
    </script>";
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="icon" href="../assets/img/dprdlogo.png">
<title>Tambah Anggota DPRD</title>

<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet">
<link href="https://demos.creative-tim.com/argon-dashboard-pro/assets/css/nucleo-icons.css" rel="stylesheet">
<link href="https://demos.creative-tim.com/argon-dashboard-pro/assets/css/nucleo-svg.css" rel="stylesheet">
<script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
<link href="../assets/css/argon-dashboard.css?v=2.1.0" rel="stylesheet">
</head>

<body class="g-sidenav-show bg-gray-100">
<div class="min-height-300 bg-dark position-absolute w-100"></div>

<!-- ================= SIDEBAR ================= -->
<aside class="sidenav bg-white navbar navbar-vertical navbar-expand-xs border-0 border-radius-xl my-3 fixed-start ms-4">
  <div class="sidenav-header">
    <a class="navbar-brand m-0">
      <img src="../assets/img/dprdlogo.png" width="26">
      <span class="ms-1 font-weight-bold">Admin DPRD</span>
    </a>
  </div>
  <hr class="horizontal dark mt-0">
  <div class="collapse navbar-collapse w-auto">
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" href="../pages/dashboard.html">Dashboard</a>
      </li>
      <li class="nav-item">
        <a class="nav-link active" href="input_anggota.php">Tambah Anggota</a>
      </li>
    </ul>
  </div>
</aside>

<!-- ================= MAIN ================= -->
<main class="main-content position-relative border-radius-lg">
<nav class="navbar navbar-main navbar-expand-lg px-0 mx-4 shadow-none">
  <div class="container-fluid py-1 px-3">
    <h6 class="text-white mb-0">Tambah Anggota DPRD</h6>
  </div>
</nav>

<div class="container-fluid py-4">
<div class="card mb-4">
<div class="card-header pb-0">
<h6>Form Tambah Anggota</h6>
</div>

<div class="card-body">
<form method="POST" enctype="multipart/form-data">
<div class="row">

<div class="col-md-6 mb-3">
<label>Nama Lengkap</label>
<input type="text" name="nama" class="form-control" required>
</div>

<div class="col-md-6 mb-3">
<label>Email</label>
<input type="email" name="email" class="form-control" required>
</div>

<div class="col-md-6 mb-3">
<label>Password</label>
<input type="password" name="password" class="form-control" required>
</div>

<div class="col-md-6 mb-3">
<label>Foto</label>
<input type="file" name="foto" class="form-control" required>
</div>

<div class="col-md-4 mb-3">
<label>Role</label>
<select name="role_id" class="form-control" required>
<?php while($r=$role->fetch_assoc()): ?>
<option value="<?= $r['id'] ?>"><?= $r['nama_role'] ?></option>
<?php endwhile; ?>
</select>
</div>

<div class="col-md-4 mb-3">
<label>Jabatan</label>
<select name="jabatan_id" class="form-control" required>
<?php while($j=$jabatan->fetch_assoc()): ?>
<option value="<?= $j['id'] ?>"><?= $j['nama_jabatan'] ?></option>
<?php endwhile; ?>
</select>
</div>

<div class="col-md-4 mb-3">
<label>Fraksi</label>
<select name="fraksi_id" class="form-control">
<option value="">-- Kosong --</option>
<?php while($f=$fraksi->fetch_assoc()): ?>
<option value="<?= $f['id'] ?>"><?= $f['nama_fraksi'] ?></option>
<?php endwhile; ?>
</select>
</div>

<div class="col-md-6 mb-3">
<label>Komisi</label>
<select name="komisi_id" class="form-control">
<option value="">-- Kosong --</option>
<?php while($k=$komisi->fetch_assoc()): ?>
<option value="<?= $k['id'] ?>"><?= $k['nama_komisi'] ?></option>
<?php endwhile; ?>
</select>
</div>

<div class="col-md-6 mb-3">
<label>AKD (boleh lebih dari satu)</label>
<select name="akd_id[]" class="form-control" multiple>
<?php while($a=$akd->fetch_assoc()): ?>
<option value="<?= $a['id'] ?>"><?= $a['nama_akd'] ?></option>
<?php endwhile; ?>
</select>
<small class="text-muted">Tahan CTRL untuk pilih lebih dari satu</small>
</div>

</div>

<button type="submit" name="simpan" class="btn btn-dark mt-3">
Simpan Anggota
</button>

</form>
</div>
</div>

<footer class="footer pt-3 text-center text-muted">
© 2025 Admin DPRD
</footer>

</div>
</main>

<script src="../assets/js/core/bootstrap.min.js"></script>
<script src="../assets/js/argon-dashboard.min.js?v=2.1.0"></script>
</body>
</html>
